'
'*******************************************************************************
'Programm ......... : TWI-Slave fr eine mehrstellige Digitalanzeige
'                     - Version: Zeit, Datum, Wochentag
'
'Programminhalt ... : Steuerung mehrerer Digitalanzeigen per TWI-Bus zur Anzeige
'                     - Zeit ........ : hh:mm:ss
'                     - Datum ....... : TT:MM:JJJJ
'                     - Wochentag ... : W
'                     Je nach Betriebsart knnen u. a. angesteuert werden:
'                     (auch gemischt)
'                     -  7-Segmentanzeigen
'                     - 16-Segmentanzeigen
'                     - LCD-Modul
'                     - einzelne LED sowie Punktmatrixanzeigen
'                     Ermittlung der Zeitangabe ber ein DCF77-Modul
'
'Programmierer .... : Ingolf Bauer (ingolf.bauer@nexgo.de)
'Version .......... : V 1.1.72
'Datum ............ : 10.02.2022
'
' Hinweise
' Label A_...          Die mit dem Prfix "A_" versehenen Labels dienen nur dem
'                      schnelleren Auffinden der Zeile im Programmcode.
' Label L_/M_...       Sprungmarken des Programms
'
'-------------------------------------------------------------------------------
'
'Zusatzbibliothek
'----------------
' Die eingesetzte Bibliothek zur MC-Konfiguration als Slave am TWI-Bus ist nicht
' Bestandteil der Bascom-Basisversion.
' Sie muss ber den Anbieter erworben werden.
'
'-------------------------------------------------------------------------------
'00. === I N F O R M A T I O N =================================================
'-------------------------------------------------------------------------------
A_000___information:
'
'Simulator-Betrieb
'-----------------
A_001_sim:                                        'Editmarker: Simulator
'
'$sim                                             'Wartezeit aus
'
'/// Achtung ///
' Diese Zeile ist unbedingt auszukommentieren, bevor der AVR programmiert wird,
' da sonst der AVR nicht korrekt arbeitet.
' Die Aktivierung ist nur fr den Programmlauf im Simulator vorgesehen.
'
'-------------------------------------------------------------------------------
'
A_002_all:                                        'Editmarker: allgemeines
'
'Allgemeines
'-----------
'-Busteilnehmer
' Nach einer neuen Programmierung ist es unbedingt erforderlich, dass alle am
' TWI-Bus angeschlossenen AVR abgeschaltet und wieder neu eingeschaltet werden.
'
'Adressierung
'~~~~~~~~~~~~
' Um einen einzelnen Slave ansprechen zu knnen, werden folgende Festlegungen
' zur Adressierung getroffen.
' Die ersten beiden Slaves befinden sich auf der Steuerplatine, die anderen auf
' den jeweiligen Erweiterungsplatinen (zwei je Platine).

' PCB  Slave  ADR   Digit Bedeutung              Zusatz
'     (Index)
'-------------------------------------------------------------------------------
' ST    01    &H22   01    h-  10 (hh:mm:ss)
'                    02    h-   1 (hh:mm:ss)     Trennzeichen (Doppelpunkt)
' ST    02    &H24   03    m-  10 (hh:mm:ss)
'                    04    m-   1 (hh:mm:ss)     Trennzeichen (Doppelpunkt)
' EW1   03    &H26   05    s-  10 (hh:mm:ss)
'                    06    s-   1 (hh:mm:ss)
'                    - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' EW1   04    &H28   07    T-  10 (TT:MM:JJJJ)
'                    08    T-   1 (TT:MM:JJJJ)   Trennzeichen (Punkt)
' EW2   05    &H2A   09    M-  10 (TT:MM:JJJJ)
'                    10    M-   1 (TT:MM:JJJJ)   Trennzeichen (Punkt)
' EW2   06    &H2C   11    J-1000 (TT:MM:JJJJ)
'                    12    J- 100 (TT:MM:JJJJ)
' EW3   07    &H2E   13    J-  10 (TT:MM:JJJJ)
'                    14    J-   1 (TT:MM:JJJJ)
'                    - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' EW3   08    &H30   15    W-   1 (W)
'                    16    --                     (frei)
'
' Die Prfung im Master auf adressierbare Slaves erfolgt bis Adresse &H3E HEX)
' (62 DEZ).
'
A_010_bedienung:                                  'Editmarker: Bedienung
'
'Bedienung
'---------
'Slave-Adresse einstellen
' /// Achtung ///
' Es ist darauf zu achten, dass Slave-Adressen nicht doppelt vergeben werden.
' Wird eine Adressnderung durchgefhrt, ist das Gesamtsystem neu zu starten,
' da die Slaves fr den Master sichtbar gemacht werden mssen.

' Variante 1
' ~~~~~~~~~~
' Beim Brennen des jeweiligen MC wird eine EEprom-Datei betragen, die die
' korrekte Slave-Adresse beinhaltet. Sie beinhaltet auf Speicheradresse &H1 den
' Adresswert als Hexadezimalwert.
' Startwert ist &H22, was 34 dezimal entspricht.
'
' Variante 2
' ~~~~~~~~~~
' Whrend des Programmablaufs wird PB.7 (Pin 10) auf L-Pegel geprft.
' Wird dieser extern angelegt, ndert sich temporr die Betriebsart des MC.
' Es wird in langsamer Abfolge der gesamte Adressbereich der mglichen Slaves
' durchlaufen und die Adresse wird dezimal angezeigt.
' Gibt man das Pin wieder frei, wird die neue Slave-Adresse in das EEprom
' geschrieben.
' Damit ist es mglich, ohne den MC oder das EEprom brennen zu mssen, die
' korrekte Slave-Adresse zuzuordnen.
'
'-------------------------------------------------------------------------------
A_020_historie:                                   'Editmarker: Historie
'
'Versionsbersicht
'-----------------
'
'
'
'
'V 1.0.72  10.02.2022 - Erweiterung . : - Anzeige fr Option Anzeige JJJJ
'                     - AVR ......... : - 42%
'V 1.0.73  16.01.2022 - Firmware .... : - Ausgabe der Version (0122)
'V 1.0.74  12.01.2022 - Korrektur ... : - nderungen aus V 1.0.70 zunchst ver-
'                                         worfen wegen Interferenzen bei der
'                                         Anzeige
'                     - AVR ......... : - 41%
'V 1.0.75  09.01.2022 - Erweiterung . : - Eingnge fr Einstellungen erweitert
'                                       - PWM-Steuerung fr Segment 8
'                                         (Helligkeit Trennzeichen)
'V 1.0.76  30.12.2021 - nderung .... : - BODLEVEL 0 (-> 4,0 V eingestellt)
'                                       - BODEN    0 (enabled)
'                                       - EEpromdummy fr ADR 0 (sinnvoll?)
'                     - AVR ......... : - 37%
'V 1.0.77  27.12.2021 - Erweiterung . : - Anzeigecode fr M
'                     - AVR ......... : - 36%
'V 1.0.81  22.12.2021 - Erweiterung . : - Anzeigecode fr AEHL, Z (Anzeige aus)
'V 1.0.87  19.12.2021 - nderung .... : - Busfrequenz auf 50 kHz reduziert
'                                       - Bus-Wartezeiten erhht
'                                       - nach einschalten 1 Sekunde warten
'                                         (Einschwingzeit)
'                                       - EEpromfreigabe erst nach 2 Minuten
'V 1.0.91  15.12.2021 - Information . : - Inbetriebnahme TWI-Bus mit Testber-
'                                         tragungen von Zahlen
'                     - Erweiterung . : - SLV-Adresswechsel bei Pin B.7 (Masse)
'                                         und Routine dazu optimiert
'                                       - Darstellung Segment H (Punkt)
'                                       - Dekoder fr Wochentagsanzeige
'                     - AVR ......... : - 28%
'V 1.0.99  10.12.2021 - Information . : - Beginn der Softwareentwicklung
'                     - AVR ......... : -  0%
'
'-------------------------------------------------------------------------------
'
'Informationen zur Software
'--------------------------
' Inhalt                                                                | Zeile
'-------------------------------------------------------------------------------
' 01. Allgemeine Informationen ........................................ |  209
' 02. Abkrzungsbersicht ............................................. |  222
' 03. Compilereinstellungen ........................................... |  226
' 04. Funktionsbeschreibung ........................................... |  249
'       Allgemeines ................................................... |  251
'       Anzeige ....................................................... |  256
'       Adressierung .................................................. |  264
' 05. Interrupt ....................................................... |  271
' 06. Einstellung der Fuse- und Lock-Bits ............................. |  275
' 07. Anschluschema fr den AVR ATmega8(A) ........................... |  319
' 08. I/O-Ports ....................................................... |  370
' 09. EEprom-Belegung ................................................. |  438
' 10. Allgemein ....................................................... |  453
' 11. AVR Initialisierung ............................................. |  459
'      Schnittstelle .................................................. |  466
'      Compilereinstellungen .......................................... |  471
' 12. Fuse- und Lockbits .............................................. |  479
' 13. Deklaration ..................................................... |  501
' 12. Konfiguration ................................................... |  571
' 12.1 I/O-Port ....................................................... |  573
'      Timer .......................................................... |  623
'      Systemzeit ..................................................... |  644
'      Interrupt ...................................................... |  654
' 15. Alias ........................................................... |  664
'      Eingang (digital) .............................................. |  667
' 16. Initialisierung ................................................. |  679
' 20. Programm ........................................................ |  692
'      Anzeige ........................................................ |  695
'      Einstellung Slave-Adresse ...................................... |  717
' 30. Interruptroutine ................................................ |  778
'      Timer 0 ........................................................ |  783
' 40. Unterprogramm-Gosub ............................................. |  814
'      Meldungen ...................................................... |  819
' 50. Unterprogramm-Call .............................................. |  850
'      Darstellung auf zwei 7-Segement-Anzeigen ....................... |  855
'      TWI-Slave ...................................................... | 1078
' 60. Funktion ........................................................ | 1125
' 70. Datenbereich .................................................... | 1130
'      ASCI    DEZ  HEX  h g f e d c b a .............................. | 1190
'-------------------------------------------------------------------------------
'
'01. Allgemeine Informationen
'----------------------------
'Taktfrequenz
' Fr die Taktfrequenz wird der internen Oszillator per Fuse-Bit auf 8 MHz ein-
' gestellt.
'
'Programmierung
' Die Programmierung der MC kann extern oder ber den vorhandenen Anschluss fr
' einen ISP-Programmer erfolgen.
' Zur Programmierung wurde das Modul "USBasp" verwendet, welches ber eine
' USB-Schnittstelle an einem PC angeschlossen wird. Es kann direkt ber eine,
' im Bascom-SDK integrierte Einstellmglichkeit angesprochen werden.
'
'02. Abkrzungsbersicht
'-----------------------
' %

'03. Compilereinstellungen
'-------------------------
' Hinweise fr ATmega8/ATmega16 und deren pinkompatiblen Versionen
' Quelle:
' //halvar.at/elektronik/kleiner_bascom_avr_kurs/speicher_hwstack_swstack_frame/
'
' HW-Stack - Empfehlung: 40 Byte bei INT, sonst 10 Byte ausreichend
'  32 Byte fr INT + je GOSUB 2 Byte, wenn bei INT ein GOSUB erfolgt
'  (bei Verschachtelung ... + n x 2 Byte)
'
' SW-Stack - Empfehlung: 32 Byte (recht komplexe Aufrufe werden abgedeckt)
'   2 Byte fr jede bergebene Variable einer GOSUB-Routine + 2 Byte fr jede
'   LOCAL-Variable innerhalb einer GOSUB
'   (bei Verschachtelung ... n x 2 Byte)
'
' Frame-Space - Empfehlung: 60 Byte sollten alles abdecken
'                           (bei wenig Speicher verkleinern)
'  Beispiel:
'   2 x BYTE        =  2 Byte (erster und zweiter Parameter)
'   1 x WORD        =  2 Byte (dritte Parameter)
'   1 x STRING * 10 = 11 Byte (inkl. Abschlussbyte; vierter Parameter)
'   3 x BYTE        =  3 Byte (lokale Variablen)
'
'04. Funktionsbeschreibung
'-------------------------
' Allgemeines
' -----------
' Beim Anschluss des Microkontrollers gibt es keine Besonderheiten zu beachten.
' Die Programmierung ber die SPI-Schnittstelle.
'
' Anzeige
' -------
'  Diese Software dient der Ansteuerung von zwei Digits einer 7-Segment-Anzei-
'  ge oder einer LED-Punktanzeige. Andere Mglichkeiten sind durch den Einsatz
'  eines MC zur Kodierung der aktiven Segmente gegeben.
'  Damit knnen nach einer Anpassung der Kodierung andere Anzeigen, wie z. B.
'  16-Segmentanzeigen eingesetzt werden.

' Adressierung
' ------------
'  Bei Modulen, die ber ein Bussystem verbunden sind, muss jeder Teilnehmer
'  eine eindeutige Slave-Adresse erhalten.
'  Wie diese bei jedem Modul eingestellt werden kann, wurde bereits im Ab-
'  schnitt "Bedienung" erlutert.
'
'05. Interrupt
'-------------
' %
'
'06. Einstellung der Fuse- und Lock-Bits
'---------------------------------------
' - Fuse-Einstellungen fr Brenner USBasp (Bascom)
'   Die aktuellen Einstellungen befinden sich im Abschnitt "A_120_fuse".
'
' - Fuse-bersicht
'   Die angegebenen HEX-Werte knnen direkt in den compilierten Programmcode
'   eingetragen werden, falls dies bei der Programmierung untersttzt wird.
'   Beim USBasp unter dem Bascom-SDK ist dies nicht mglich.
'
' Bedeutung der Fuse/Lock-Bit-Einstellungen
' Name              ATmega8(A)
'   Calibration 0   BD  (ohne Bedeutung)
'   Calibration 1   BC  (ohne Bedeutung)
'   Calibration 2   B7  (ohne Bedeutung)
'   Calibration 3   B7  (ohne Bedeutung)
' * Lockbits        FF
'    Lockbit 65       11: No restrictions for SPM or LPM accessing ...
'    Lockbit 43       11: No restrictions for SPM or LPM accessing ...
'    Lockbit 21       11: No memory lock features enabled for parallel ...
' * Fusebits        C4
'    Fusebit C         1: BODLEVEL 2.7V
'    Fusebit B         1: BODEN disabled
'    Fusebit KLA987   000100: Int. RC Osc. 8 MHz
' * Fusebits Hight  D1
'    Fusebit High M    1: PIN PC6 is RESET
'    Fusebit High J    1: WDT enabled by WDTCR
'    Fusebit High I    0: SPI enabled
'    Fusebit High H    1: CKOPT 1
'    Fusebit High G    0: Preserve EEPROM when chip erase
'    Fusebit High FE  00: 1024 word boot size, C00
'    Fusebit High D    1: Reset vector is $0000

' /// Achtung ///
' CKSEL
'  Wird CKSEL3= 0 gesetzt, arbeitet der MC nur noch mit einem externen RC-
'  Generator [f= 1/(3RC); C>= 22p].
'
' PortC.6
'  Fr diesen Kanal muss die Betriebsart "Reset" eingestellt sein, wenn der MC
'  auf diesem Kanal die /Reset-Funktion vorgesehen ist (z. B. ATmega8).
'
A_070_pin:                                        'Editmarker: Pin
'
'07. Anschluschema fr den AVR ATmega8(A)
'----------------------------------------
'/// Achtung ///
' Die Pinbelegung bezieht sich auf einen ATmega8(A) im DIL28-Gehuse.
'
'                    --------------------|_|-------------------
' [1]    /Reset ---> | 1 [PC6, /Reset]     [SLC, ADC5, PC5] 28| <--> SLC    [B]
' [0]    ANZ_11 <--- | 2 [PD0, RXD]        [SDA, ADC4, PC4] 27| <--> SDA    [B]
' [0]    ANZ_12 <--- | 3 [PD1, TXD]             [ADC3, PC3] 26| ---> ANZ_24 [0]
' [0]    ANZ_13 <--- | 4 [PD2, INT0]            [ADC2, PC2] 25| ---> ANZ_23 [0]
' [0]    ANZ_14 <--- | 5 [PD3, INT1]            [ADC1, PC1] 24| ---> ANZ_22 [0]
' [0]    ANZ_15 <--- | 6 [PD4, T0]              [ADC0, PC0] 23| ---> ANZ_21 [0]
'         P5,0V ==== | 7 [VCC]                       [AGND] 22| ==== GND
'           GND ==== | 8 [GND]                       [AREF] 21| -||-
' [0]    ANZ_28 <--- | 9 [PB6, XTAL1]                [AVCC] 20| ==== P5,0V
' [1] (manuell) ---> |10 [PB7, XTAL2]             [SCK,PB5] 19| <--- SCK    [~]
' [0]    ANZ_16 <--- |11 [PD5, T1]               [MISO,PB4] 18| ---> MISO   [~]
' [0]    ANZ_17 <--- |12 [PD6, AIN0]             [MOSI,PB3] 17| <--- MOSI   [~]
' [0]    ANZ_18 <--- |13 [PD7, AIN1]             [/SS, PB2] 16| ---> ANZ_27 [0]
' [0]    ANZ_25 <--- |14 [PB0, ICP]              [OC1, PB1] 15| ---> ANZ_26 [0]
'                    ------------------------------------------
'
' Standard-Einstellungen nach dem Programmstart
'  [^]: Impuls              [~]: unbestimmt          [&]: PWM
'  [0]: aus (GND)           [1]: ein (Vcc)           [%]: analog
'  [$]: SPI-Bus             [W]: 1-Drahtbus          [#]: I2C-Bus
'  [=]: Stromversorgung     [+]: Quarz               []: nicht verwendbar
'  [.]: nicht angeschlossen (Reservekanal)           [-]: nicht relevant
'
' Datenrichtung ..... : ---- / ---> / <--- / <-->
' Stromversorgung ... : ====
' Quarz ............. : ++++
' Kondensator ....... : -||-
'
'Allgemein
'~~~~~~~~~
' Px,yV   : Stromversorgung P5,0V / P3,3V
' GND     : Stromversorgung Masse
'
' MISO    : Programmieranschlu
' MOSI    : Programmieranschlu
' SCK     : Programmieranschlu
'
' DA      : digitaler Ausgang
' DE      : digitaler Eingang
' PG      : Programmierung
' SV      : Stromversorgung
' SPI     : Busprotokoll
' TWI     : Busprotokoll
' USI     : Busprotokoll (universelle Schnittstelle)
'
'08. I/O-Ports
'-------------
' /Reset  : Resetfunktion
' ADR     : Funktionsaufruf Slave-Adressierung
' ANZ_    : Anzeige eines Segments
' SDA     : Busanschluss (Daten)
' SLC     : Busanschluss (Takt)
'
' _<yx>    : Segment yx (y: 1, 2; x: 1-8) fr Zehner- und Einer-Digist
'
' P5V     : Stromversorgung P 5V
' GND     : Stromversorgung Masse
'
' MISO    : Programmieranschlu
' MOSI    : Programmieranschlu
' SCK     : Programmieranschlu

'           Funktion     | Signal        | Erluterung                    | Pin
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' -   : SV  P5,0V ...... | ............. | Stromversorgung .............. |  7
' -   : SV  P5,0V ...... | ............. | Stromversorgung .............. | 20
' -   : SV  GND ........ | ............. | Stromversorgung .............. |  8
' -   : SV  GND ........ | ............. | Stromversorgung .............. | 22
' -   : SV  (intern) ... | ............. | Referenzspannung ............. | 21
' -   : PRG /RESET ..... | ............. | Programmierung/Reset des MCs . |  1
'
'Port B     Funktion     | Signal        | Erluterung                    | Pin
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' - .0: DA  Anzeige .... | ANZ_25 ...... | Zehner Segmentsteuerung ...... | 14
' - .1: DA  Anzeige .... | ANZ_26 ...... | Zehner Segmentsteuerung ...... | 15
' - .2: DA  Anzeige .... | ANZ_27 ...... | Zehner Segmentsteuerung ...... | 16
' - .3: PRG MOSI ....... | MOSI ........ | Programmierung ............... | 17
' - .4: PRG MISO ....... | MISO ........ | Programmierung ............... | 18
' - .5: PRG SCK ........ | SCK ......... | Programmierung ............... | 19
' - .6: DA  Anzeige .... | ANZ_28 ...... | .............................. | nc
' - .7: DE  ADR ........ | (L-Pegel) ... | .............................. | nc
'
'Port C     Funktion     | Signal        | Erluterung                    | Pin
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' - .0: DA  Anzeige .... | ANZ_21 ...... | Zehner Segmentsteuerung ...... | 23
' - .1: DA  Anzeige .... | ANZ_22 ...... | Zehner Segmentsteuerung ...... | 24
' - .2: DA  Anzeige .... | ANZ_23 ...... | Zehner Segmentsteuerung ...... | 25
' - .3: DA  Anzeige .... | ANZ_24 ...... | Zehner Segmentsteuerung ...... | 26
' - .4: B   Daten (Bus). | SDA ......... | TWI-Bussystem ................ | 27
' - .5: B   Takt  (Bus . | SLC ......... | TWI-Bussystem ................ | 28
' - nc: ... ............ | ............. | .............................. | nc
' - nc: ... ............ | ............. | .............................. | nc
'
'Port D     Funktion     | Signal        | Erluterung                    | Pin
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' - .0: DA  Anzeige .... | ANZ_11 ...... | Einer Segmentsteuerung ....... |  2
' - .1: DA  Anzeige .... | ANZ_12 ...... | Einer Segmentsteuerung ....... |  3
' - .2: DA  Anzeige .... | ANZ_13 ...... | Einer Segmentsteuerung ....... |  4
' - .3: DA  Anzeige .... | ANZ_14 ...... | Einer Segmentsteuerung ....... |  5
' - .4: DA  Anzeige .... | ANZ_15 ...... | Einer Segmentsteuerung ....... |  6
' - .5: DA  Anzeige .... | ANZ_16 ...... | Einer Segmentsteuerung ....... | 11
' - .6: DA  Anzeige .... | ANZ_17 ...... | Einer Segmentsteuerung ....... | 12
' - .7: DA  Anzeige .... | ANZ_18 ...... | Einer Segmentsteuerung ....... | 13
'
'Erluterung
' B  : Bussystem
' DA : digitaler Ausgang
' DE : digitaler Eingang
' PRG: Programmierung
' SV : Stromversorgung
'
'-------------------------------------------------------------------------------
'
'09. EEprom-Belegung
'-------------------
A_090_eeprom:                                     'Editmarker: Eprom
'
'Adresse   | Inhalt
' Dez  Hex |
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' 000  00  | (EEpromdummy)
' 001  01  | Slave-Adresse n (n: &H22-&H3E, entspricht 34-62 dezimal)
'
'Hinweis
' Die Begrenzung auf &H3E (8 Slaves )ist fr das aktuelle Projekt entsprechend
' der Funktionalitt festgelegt.
'
'-------------------------------------------------------------------------------
'10. === A L L G E M E I N =====================================================
'-------------------------------------------------------------------------------
'
A_100_allgemein:                                  'Editmarker: Allgemein
A_110_def:                                        'Editmarker: Definition
'
'11. AVR Initialisierung
'-----------------------
   $regfile = "m8adef.dat"
'Die folgende Anweisung entfllt, da der internen RC-Oszillator mit 8 MHz per
'Fuse-Bit eingestellt werden muss.
'  $crystal = 8000000

'Schnittstelle
'-------------
' ggf. fr eine Ausgabe im Simulator-Feld (UART)
'  $baud = 9600                                   'Baudrate ........ : 9600
                                                  '9600/19200/38400/57600/115200
'Compilereinstellungen
'---------------------                            Archiv
   $hwstack = 64                                  '-
   $swstack = 64                                  '-
   $framesize = 64                                '-

A_120_fuse:                                       'Editmarker: Fuse
'
'12. Fuse- und Lockbits
'----------------------
'USBasp: Werte generiert mit "Write PRG"

' $PROG &HFF, &H04, &HD1, &H00
'
' FF: 11 11 11
' 04: 0 0 000100
' D1: 1 1 0 1 0 00 1
' 00: 0
' - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
' Archiv
' $PROG &HFF, &HC4, &HD1, &H00 -> V~77 BODEN 0   : berwachung ein
'                              -> V~77 BODLEVEL 0: 2,7 V -> 4,0 V
' $prog &HFF, &Hxx, &Hxx, &H00 -> - interner Oszillator 8 MHz
'                                 - EEprom bei PRG nicht lschen
'
'-------------------------------------------------------------------------------
'
A_000_deklaration:                                'Editmarker: Deklaration
A_130_deklaration:                                'Editmarker: Deklaration
'
'13. Deklaration
'---------------
'Bibliothek
'~~~~~~~~~~
' Funktion TWI-Bus (Hardware)
' Diese Bibliothek ist nicht Bestandteil von Bascom, wird aber bentigt, um
' einen ATmega8 als Slave in einem I2C-Bussystem zu betreiben.

   $lib "i2c_twi-slave.lbx"

'Variablen im EEprom
   Dim E_00 As Eram Byte                          '&H00: EEpromdummy
   Dim E_adr_slv As Eram Byte                     '&H01: Slave-Adresse

' Anzeige eines Werts
   Dim V_anz As Byte                              'Anzeige (Zahl)
   Dim Slv_anz As String * 2                      'Anzeige (Text)
   Dim Slv_01 As String * 1                       'Digit Einer
   Dim Slv_10 As String * 1                       'Digit Zehner

' Anzeige einer Meldung
   Dim V_mel As Byte                              'Index fr
   Dim V_c1 As Byte                               'Zeichen links
   Dim V_c2 As Byte                               'Zeichen rechts

' TWI-Bus
   Dim Adr_slv As Byte                            'Slave
   Dim Slv_adr As Byte                            'Slave-Adresse
   Dim Slv_wer As Byte                            'Wert beider Digits
   Dim Slv_prf As Byte                            'Prfwert

' Abfrage Eingnge fr Einstellungen
   Dim E_bit As Byte                              'Abfrage per Timer

'Konstante
' Allgemein
   Dim K_slv As Byte                              'Anzahl

'Merker
' Hilfsmerker
   Dim M_slv As Byte                              'letzte Slave-Adresse

' Flag
   Dim F_anz As Bit                               'Anzeige: Wert
   Dim F_mel As Bit                               'Anzeige: Meldung
   Dim F_slv As Bit                               'Slave-Adresse festlegen

'Timer
' Voreinstellwerte
   Dim T0_tve As Byte                             'Timer 0: Voreinstellwert

' Zhler
   Dim Hzt As Byte                                'Zeitzhler Anzeige
   Dim Z_pwm As Byte                              'Zeitzhler PWM
   Dim Z_pin As Word                              'Zeitzhler Pinabfrage

'Watchdog
'~~~~~~~~
   Config Watchdog = 2048
   Start Watchdog

'7-Segment-Ansteuerung - Wert
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~
' Der ber den Bus an den Slave bertragene Wert wird nach einer Zuordnungspr-
' fung auf dem Doppelanzeige dargestellt.
' z. B. ist Slave 1 (Adresse &H22) fr die Darstellung der Stunden zustndig
   Declare Sub Cup_anz(byval V_ez As Byte)
'
'-------------------------------------------------------------------------------
'
'12. Konfiguration
'-----------------
'12.1 I/O-Port
'-------------
'Port B
'-Datenrichtung (Ein [0]: Eingang, Aus [1]: Ausgang)
   Ddrb = &B0100_0111                             'PB3-5,7 Ein, 0-2,6 Aus
'-Pullup-Widerstand (passiv [0], aktiv [1])
   Portb = &B1000_0000                            'PB7 aktiv, 0-6 passiv
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
'Port C
'-Datenrichtung (Ein [0]: Eingang, Aus [1]: Ausgang)
   Ddrc = &B0000_1111                             'PC0-3 Aus, 4-7 Ein
'-Pullup-Widerstand (passiv [0], aktiv [1])
   Portc = &B0100_0111                            'PC3-5,7 passiv, 1-2,6 aktiv
'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
'Port D
'-Datenrichtung (Ein [0]: Eingang, Aus [1]: Ausgang)
   Ddrd = &B1111_1111                             'PD0-7 Aus
'-Pullup-Widerstand (passiv [0], aktiv [1])
   Portd = &B0000_000                             'PD0-7 passiv
'
'-------------------------------------------------------------------------------
'
A_131_twi:                                        'Editmarker: TWI-Bus
'
'Konfiguration TWI-Bus
'~~~~~~~~~~~~~~~~~~~~~
'Da mit der selben Software unterschiedliche Slave-Adressierungen realisiert
'sind, wird die gltige Adresse aus dem EEProm ausgelesen.
'Im Programm ist ein Routine vorhanden, die es ermglicht, diese Adresse zu
'ndern. Es ist auerdem mglich, eine entsprechende Datei direkt in das EEprom
'zu schreiben.

'Ermittlung der Slave Adresse
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~
   Waitms 200                                     'Einschwingzeit
   Adr_slv = E_adr_slv
   If Adr_slv = &HFF Or Adr_slv < &H22 Then
      Adr_slv = &H22                              'Startadresse
      E_adr_slv = Adr_slv
   End If

'<Twislave> ... : Adresse Slave        (Bereich &H22-&H3E)
'<Btr> ........ : Anzahl Datenbyte     (3)
'<Bitrate> .... : Busfrequenz          (5000 => 50 kHz)
   Config Twislave = Adr_slv , Btr = 3 , Bitrate = 50000 , Gencall = 1
'
'-------------------------------------------------------------------------------
'
A_142_timer:                                      'Editmarker: Timer
'
'Timer
'-----
'/// Achtung ///
' Fr den Betrieb mit einem DCF-Empfnger (Funkuhr) ist Timer 1 erforderlich.
' Eine Konfiguration ist nicht erforderlich.
'
'Normal-Konfiguration
' Die Interrupts der Timer werden beim jeweiligen Timerberlauf ausgelst.
' PSC: Vorteiler; TZW: Zhlwert; TVE: Voreinstellwert
' [mgliche Werte fr PSC: 1-8-64-256-1024]
'
'> Konfiguration bei einer Taktfrequenz von 8 MHz (TF)
'  T0: 0,001  s ( 1.000 Hz); 8-bit Zhler
'                                PSC  TZW   T       f                   TVE
'  T0 = 1/ TF* Teiler (1/ 4 MHz*  64*  62 = 1,0 ms;  992 Hz) 256-  62 = 194
'  T0 = 1/ TF* Teiler (1/ 8 MHz*  64* 125 = 1,0 ms; 1000 Hz) 256- 125 = 131
'  T0 = 1/ TF* Teiler (1/16 MHz*  64* 250 = 1,0 ms; 1000 Hz) 256- 250 =   6
'
'  T0: 0,0001 s (10.000 Hz); 8-bit Zhler
'* T0 = 1/ TF* Teiler (1/ 8 MHz*   8* 156 = 0,1 ms; 10x3 Hz) 256- 99  = 157
'
'Systemzeit
'----------
' Timer 0: Voreinstellung auf Wert "TVE" und innerhalb der Interrupt-Routine
' (100 s bzw. 0,1 ms)
   Config Timer0 = Timer , Prescale = 8           'Konfiguration
      T0_tve = 156                                'TVE: Voreinstellwert
      Timer0 = T0_tve                             'Timer 0: Voreinstellung

A_143_int:                                        'Editmarker: Interrupt
'
'Interrupt
'---------
   Enable Timer0                                  'Timer 0: Interrupt
      On Timer0 Int_tim0                          'Timer 0: berlauf (UP)
   Enable Interrupts
'
'-------------------------------------------------------------------------------
'
A_150_alias:                                      'Editmarker: Alias
'
'15. Alias
'---------
'Port B
'Eingang (digital)
'-----------------
'Pinabfrage zur Ermittlung der Optionsnummer
   E_bit0 Alias Pinb.7                            'Eingang Einstellungen (Bit 0)
   E_bit1 Alias Pinb.3                            'Eingang Einstellungen (Bit 1)
   E_bit2 Alias Pinb.4                            'Eingang Einstellungen (Bit 2)
   E_bit3 Alias Pinb.5                            'Eingang Einstellungen (Bit 3)
'
'-------------------------------------------------------------------------------
'
A_160_init:                                       'Editmarker: Initialisierung
'
'16. Initialisierung
'-------------------
A_161_konstante:                                  'Editmarker: Konstante
'
   K_slv = 8                                      'Slave-Anzahl
   M_slv = K_slv * 2 : M_slv = M_slv + &H20       'letzte Slave-Adress

   V_anz = 0
   Call Cup_anz(v_anz)                            'Anzeige: 00

A_000_programm:                                   'Editmarker: Deklaration
A_200_programm:                                   'Editmarker: Programm
'
'20. Programm
'------------
Do
'Anzeige
'-------
' Die Anzeige wird aktualisiert, wenn der Master die Daten bereitgestellt hat.
' Zunchst wird nach einer komplette Datenbertragung (3 Bytes) geprft, ob
' der Slave, fr den die Daten gedacht sind, der aktuelle ist (Byte 1).
' Danach erfolgt die bertragung des Anzeigewertes (Byte 2.
' Wenn die Prfung mit dem Prfwert (Wert*2, Byte 3) korrekt ist, wird der Wert
' angezeigt.
   If F_anz = 1 And F_mel = 0 Then                'Anzeige: ja, Meldung: nein
      Reset F_anz
      If Slv_adr = Adr_slv Or Slv_adr = 0 Then    'Slave ist angesprochen
         Reset F_anz                              '0: CQ (an alle)
'Anzeigewert mit Prfwert vergleichen
         Shift Slv_prf , Right , 1
         If Slv_prf <> Slv_wer Then               'Prfdifferenz
            Goto M_end
         Else
            Call Cup_anz(slv_wer)                 'Anzeige aktualisieren
         End If
      End If
   End If

'Einstellung Slave-Adresse
'-------------------------
'Alle 100 ms erfolgt timergesteuert die Abfrage der Pins PB.2, PB.3, PB.4 und
'PB.7. Das Ergebnis wir in der Variablen <E_bit> abgelegt.
'Der eingeschrnkte Wertebereich fr die Optionen ist darin begrndet, dass PB.7
'immer als Select-Signal fr den jeweils ausgewhlten Slave verwendet wird.
'Die Werte haben folgende Bedeutung:
' 1: Einstellung der Slave-Adresse
'    Alle 3 s wird die nchste Adresse angezeigt. Bei einem Pegelwechsel n-
'    dert sich der Wert in der Variablen und die neue Slave-Adresse wird im
'    EEprom hinterlegt.
'    Achtung: Die Anzeige erfolgt dezimal.
' (bisher nicht benutze Optionen: 3, 5, 7, 9, 11, 13, 15)

   Select Case E_bit
      Case 1
         Waitms 300                               'entprellen
          If E_bit = 1 Then                       'Option noch gewhlt
            Set F_mel                             'Flag Meldung
'Meldungsanzeige: SL
            V_mel = 1                             'Meldungsnummer 1
            Set F_slv                             'Anzeigesteuerung
            Gosub Up_mel                          'Anzeige Meldung
M_pin:
            If Adr_slv > M_slv Then               'Bereich berschritten
               Adr_slv = &H22                     '34: Startwert (dezimal)
            End If
            Call Cup_anz(adr_slv)                 'Slave-Adresse anzeigen

            For Hzt = 1 To 3                      'entspricht Waitms 1500
               Reset Watchdog
               Waitms 500
            Next Hzt
            If E_bit = 1 Then                     'Option noch gewhlt
               Adr_slv = Adr_slv + 2              'Adresse hochzhlen
               Goto M_pin                         'weitere Abfrage
            End If
         End If
         E_adr_slv = Adr_slv                      'Slave-Adreesse > EEprom
'Meldungsanzeige: --
         V_mel = 2                                'Meldungsnummer 2
         Gosub Up_mel                             'Anzeige Meldung
         Slv_wer = 0
         Call Cup_anz(slv_wer)                    'Anzeige aktualisieren
         Reset F_mel                              'Flag Meldung
         Reset F_slv
         Goto 0                                   'Start Initialisierung
   End Select

M_end:
'Ende Programmschleife
   Reset Watchdog

Loop
'Ende Programm
End
'===============================================================================

A_300___interrupt:                                'Editmarker: Interrupt
'
'-------------------------------------------------------------------------------
'30. === I N T E R R U P T R O U T I N E =======================================
'-------------------------------------------------------------------------------
'
A_310_int_t0:                                     'Editmarker: INT T0
'
'Timer 0
'-------
'Timer 0 dient als allgemeiner Taktgeber.
'
Int_tim0:
'Timer-Interrupt: 100 s
   Timer0 = T0_tve                                'Voreinstellung des Zhlers
   Incr Z_pin                                     'Zeitbasis 0,1 ms

'Abfrage der Eingnge fr Einstellvorgnge
'~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
' Dazu werden die Pins PB3, PB4, PB5 und PB7 zyklisch abgefragt und in der
' Variable <E_bit> abgelegt.
' Fr die Auswertung ist zu beachten, dass PB.7 je Slave frei verfgbar ist.
' Die anderen Eingnge, bei denen es sich um die Programmiereingnge MOSI, MISO
' und SCK handelt, liegen parallel, sowohl am Master, als auch an allen Slaves
' an.
   If Z_pin = 1000 Then                           'Abfrage alle 100 ms
      Z_pin = 0
      E_bit.0 = Not E_bit0                        'PB.7
      E_bit.1 = Not E_bit1                        'PB.3
      E_bit.2 = Not E_bit2                        'PB.4
      E_bit.3 = Not E_bit3                        'PB.5
   End If

Int0_ret:
Return

A_400___up_gosub:                                 'Editmarker: UP Gosub
'
'-------------------------------------------------------------------------------
'40. === U N T E R P R O G R A M M - G O S U B =================================
'-------------------------------------------------------------------------------
'
A_310_mel:                                        'Editmarker: Meldungsanzeige
'
'Meldungen
'---------
' Fr die Ansteuerung der Segmente bei Meldungen kann jeder festgelegt Segment-
' code angewendet werden.
Up_mel:
   Select Case V_mel
      Case 1
         V_c1 = 56                                'L: rechts
         V_c2 = 109                               'S: links
      Case 2
         V_c1 = 64                                '-: rechts
         V_c2 = 64                                '-: links
   End Select

'Port D
   Portd = V_c2
'Port B
   Portb.0 = v_c1.4 : Portb.1 = v_c1.5
   Portb.2 = V_c1.6 : Portb.6 = V_c1.7
'Port C
   Portc.0 = v_c1.0 : Portc.1 = v_c1.1
   Portc.2 = v_c1.2 : Portc.3 = v_c1.3

   For Hzt = 1 To 6                               'entspricht Wait 3
      Reset Watchdog
      Waitms 500
   Next Hzt

Return

'-------------------------------------------------------------------------------
'50. === U N T E R P R O G R A M M - C A L L ===================================
'-------------------------------------------------------------------------------
'
A_510_seg:                                        'Editmarker: Segment-Kodierung
'
'Darstellung auf zwei 7-Segement-Anzeigen
'----------------------------------------
'Werte
' Die Ansteuerung aller Segmente einer Anzeige (2x 7 Segmente/Punkt) erfordert
' durch den Einsatz eines ATmega8 die Verteilung der Zehneranzeige auf die auch
' fr andere Funktionen genutzten Ports B und C.

Sub Cup_anz(byval V_ez As Byte)
'Wandlung bei Sonderanzeigen
   If V_ez > 99 Then                              'Wert ist ein Text
      Select Case V_ez
         Case 100
            Slv_anz = "ZZ"                        'Anzeige lschen
         Case 101
            Slv_anz = "PA"                        'ABK: Programmauswahl
         Case 102
            Slv_anz = "AC"                        'ABK: Anzeige Kontrast
         Case 103
            Slv_anz = "AH"                        'ABK: Anzeige Helligkeit
         Case 104
            Slv_anz = "LH"                        'ABK: LED Helligkeit
         Case 105
            Slv_anz = "SA"                        'ABK: Slaveanzahl
         Case 106
            Slv_anz = "SH"                        'ABK: Steuerung Helligkeit
         Case 107
            Slv_anz = "EA"                        'ABK: Einstellung Anzeige

         Case 111
            Slv_anz = "H-"                        'ABK: Stunden Zehner
         Case 112
            Slv_anz = "-H"                        'ABK: Stunden Einer
         Case 113
            Slv_anz = "M-"                        'ABK: Minuten Zehner
         Case 114
            Slv_anz = "-M"                        'ABK: Minuten Zehner
         Case 115
            Slv_anz = "S-"                        'ABK: Sekunden Zehner
         Case 116
            Slv_anz = "-S"                        'ABK: Sekunden Zehner

         Case Else
            Slv_anz = "[]"                        'ABK: (kein Eintrag)

      End Select
      Goto M_anz                                  'zur Anzeige
   End If

   Slv_anz = Str(v_ez)                            'Wert -> Textformat
   Slv_anz = Format(slv_anz , "00")               'Textformat "00"

'Index der Anzeige ermitteln
' Hinweis
' Der Einsatz von Lookup und Lookupstr fhrte teilweise zu falschen Anzeigen bis
' zu einer trgeren Anzeigezeit und schlielich zum Stillstand.
' Durch die Addition von 128 wird der Punkt (Segment h = 2^7) angezeigt.

' Zehner
' Diese Anzeige erfolgt bei allen Slave-Adressen.
M_anz:
   Slv_10 = Left(slv_anz , 1)                     'Digit Zehner
   Select Case Asc(slv_10)
      Case 48                                     '0
         V_anz = 63
      Case 49                                     '1
         V_anz = 6
      Case 50                                     '2
         V_anz = 91
      Case 51                                     '3
         V_anz = 79
      Case 52                                     '4
         V_anz = 102
      Case 53                                     '5
         V_anz = 109
      Case 54                                     '6
         V_anz = 125
      Case 55                                     '7
         V_anz = 7
      Case 56                                     '8
         V_anz = 127
      Case 57                                     '9
         V_anz = 111
'Sonderzeichen
      Case 45                                     '-
         V_anz = 64
      Case 65                                     'A
         V_anz = 119
      Case 67                                     'C
         V_anz = 57
      Case 69                                     'E
         V_anz = 121
      Case 72                                     'H
         V_anz = 118
      Case 76                                     'L
         V_anz = 56
      Case 77                                     'M
         V_anz = 55
      Case 80                                     'P
         V_anz = 115
      Case 83                                     'S
         V_anz = 109
      Case 90                                     'Z (Anzeige aus)
         V_anz = 0
      Case 91                                     '[
         V_anz = 57
      Case 93                                     ']
         V_anz = 15
   End Select

   Portd = V_anz                                  'Anzeige ber Port D

' Einer
' Diese Anzeige erfolgt nur bei den Slaves mit der Adressierung &H22 bis &H2E.
' Beim letzten Slave (&H30) ist fr die Wochentage eine LED-Anteuerung reali-
' siert
   Slv_01 = Right(slv_anz , 1)                    'Digit Einer

   If Adr_slv <> &H30 Or F_slv = 1 Then           'Zeit oder SLV-ADR-Einstlg.
      Select Case Asc(slv_01)
         Case 48                                  '0
            V_anz = 63
         Case 49                                  '1
            V_anz = 6
         Case 50                                  '2
            V_anz = 91
         Case 51                                  '3
            V_anz = 79
         Case 52                                  '4
            V_anz = 102
         Case 53                                  '5
            V_anz = 109
         Case 54                                  '6
            V_anz = 125
         Case 55                                  '7
            V_anz = 7
         Case 56                                  '8
            V_anz = 127
         Case 57                                  '9
            V_anz = 111
'Sonderzeichen
         Case 45                                  '-
            V_anz = 64
         Case 65                                  'A
            V_anz = 119
         Case 67                                  'C
            V_anz = 57
         Case 69                                  'E
            V_anz = 121
         Case 72                                  'H
            V_anz = 118
         Case 76                                  'L
            V_anz = 56
         Case 77                                  'M
            V_anz = 55
         Case 80                                  'P
            V_anz = 115
         Case 83                                  'S
            V_anz = 109
         Case 90                                  'Z (Anzeige aus)
            V_anz = 0
         Case 91                                  '[
            V_anz = 57
         Case 93                                  ']
            V_anz = 15
      End Select

'Port B
      Portb.0 = V_anz.4 : Portb.1 = V_anz.5
      Portb.2 = V_anz.6
'Port C
      Portc.0 = V_anz.0 : Portc.1 = V_anz.1
      Portc.2 = V_anz.2 : Portc.3 = V_anz.3
   Else
'Alle Einzel-LED werden ausgeschaltet und je nach bertragenden Wochentag von
'Montag bis Sonntag eingeschaltet.
'Port B
      Reset Portb.0 : Reset Portb.1
      Reset Portb.2
'Port C
      Reset Portc.0 : Reset Portc.1
      Reset Portc.2 : Reset Portc.3

      Select Case Asc(slv_01)
         Case 49                                  '1
            Set Portc.0
         Case 50                                  '2
            Set Portc.1
         Case 51                                  '3
            Set Portc.2
         Case 52                                  '4
            Set Portc.3
         Case 53                                  '5
            Set Portb.0
         Case 54                                  '6
            Set Portb.1
         Case 55                                  '7
            Set Portb.2
      End Select
   End If

'Steuerung Segment H (fr blinkenden Doppelpunkt im Format hh:mm:ss)
'Die Steuerung erfolgt im Sekundentakt. Diese wird ber Slave &H26 realisiert.
'Die LED sind auf der Leiterplatte entsprechend anzuschlieen (Ltpads).
   Select Case Adr_slv
'Die Anzeige Doppelpunk erfolgt durch Slave &H26 (ss).
'Die permanente Punktanzeige beim Datum erfolgt bei den Slaves &H28 und &H2A.
      Case &H26
         Set Portb.6                              'Punkt Ein
         Set Portd.7                              'Punkt Ein
         Reset Watchdog
         Waitms 500
         Reset Portb.6                            'Punkt Aus
         Reset Portd.7                            'Punkt Aus
      Case &H28
         Set Portb.6                              'Punkt Ein
      Case &H2A
         Set Portb.6                              'Punkt Ein
   End Select

End Sub

A_520_twi:                                        'Editmarker: Daten TWI-Bus
'
'TWI-Slave
'---------
'Die folgenden Sprungmarken werden von der Bibliothek aufgerufen.
'
'Master sendet Daten
Twi_gotdata:
   Select Case Twi_btw
      Case 1
         Slv_adr = Twi
      Case 2
         Slv_wer = Twi
      Case 3
         Slv_prf = Twi
         Set F_anz                                'Flag: Anzeige aktualisieren
   End Select

Return

'Master sent stop or repeated start
' (nicht bentigt)
Twi_stop_rstart_received:
Return

'We were addressed and master will send data.
' (nicht bentigt)
Twi_addressed_goread:
Return

'We were addressed and master will read data.
' (nicht bentigt)
Twi_addressed_gowrite:
Return

'This label is called when the master receives data and needs a byte
'the variable twi_btr is a byte variable that holds the index of the needed byte
'so when sending multiple bytes from an array, twi_btr can be used for the index
' (nicht bentigt)
Twi_master_needs_byte:
'  Twi = 255                                      '<Twi> muss einen Wert haben
Return

'When the master has all bytes received this label will be called.
' (nicht bentigt)
Twi_master_need_nomore_byte:
Return

'-------------------------------------------------------------------------------
'60. === F U N K T I O N =======================================================
'-------------------------------------------------------------------------------
'%

'-------------------------------------------------------------------------------
'70. === D A T E N B E R E I C H ===============================================
'-------------------------------------------------------------------------------
'
'Ende Datenbereich
'
' /// Achtung ///
' Die Lookup-Funktion sowie die Zusatzbibliothek fr die Funktion "Lockupstr"
' arbeiten instabil.
'
A_710_7sc:                                        'Editmarker: 7-Segmentcode
'
'7-Segment Kodierung
'~~~~~~~~~~~~~~~~~~~
'Folgende Anzeigen knnen dargestellt werden.
' Die Zhlung beginnt mit 0.
'Seg_anz:
'   Data "0" , "1" , "2" , "3" , "4" , "5" , "6" , "7" , "8" , "9" , _
'        "A" , "B" , "C" , "D" , "E" , "F" , "i" , "M" , "o" , "r" , _
'        "S", _
'        "x"
'Seg_cod:
'   Data 63 , 6 , 91 , 79 , 102 , 109 , 125 , 7 , 127 , 111 , _
'        119 , 124 , 57 , 94 , 121 , 113 , 4 , 55 , 92 , 80 , _
'        109 , _
'        0

'Slave Adressen
'Sla_adr:
'   Data &H22 , &H24 , &H26 , &H28 , &H2A , &H2C , &H2E , &H30
'
'LP         Basisplatine
'                         Zusatzpl. 1
'                                       Zusatzpl. 2
'                                                     Zusatzpl. 3
'Trennungszeichen
'~~~~~~~~~~~~~~~~
'Punktdarstellung            P      P     P
'LED-Darstellung                                                L
'           &H22   &H24   &H26   &H28   &H2A   &H2C   &H2E   &H30
'             00  :  00  :  00     00  .  00  .  00     00     1-7: LED
'             hh  :  mm  :  ss     TT  .  MM  .  JJ     JJ     WT
' Zeit        ----------------
' Datum                            -----------------------
' Wochentag                                                    --

' 7-Segment Kodierung
'~~~~~~~~~~~~~~~~~~~~
'   --a--
'  |     |
'  f     b
'  |     |
'   --g--
'  |     |
'  e     c
'  |     |
'   --d--' o h
'
'Ansteuerung der Segmente
'~~~~~~~~~~~~~~~~~~~~~~~~
'             Segment
'ASCI    DEZ  HEX  h g f e d c b a
'-----------------------------
'048  0   63   3F  0 0 1 1 1 1 1 1
'049  1    6   06  0 0 0 0 0 1 1 0
'050  2   91   5B  0 1 0 1 1 0 1 1
'051  3   79   4F  0 1 0 0 1 1 1 1
'052  4  102   66  0 1 1 0 0 1 1 0
'053  5  109   6D  0 1 1 0 1 1 0 1
'054  6  125   7D  0 1 1 1 1 1 0 1
'055  7    7   07  0 0 0 0 0 1 1 1
'056  8  127   7F  0 1 1 1 1 1 1 1
'057  9  111   6F  0 1 1 0 1 1 1 1
'- - - - - - - - - - - - - - -
'065  A  119   77  0 1 1 1 0 1 1 1
'098  b  124   7C  0 1 1 1 1 1 0 0
'067  C   57   39  0 0 1 1 1 0 0 1
'100  d   94   5E  0 1 0 1 1 1 1 0
'069  E  121   79  0 1 1 1 1 0 0 1
'070  F  113   71  0 1 1 1 0 0 0 1
'- - - - - - - - - - - - - - -
'072  H  118   76  0 1 1 1 0 1 1 0
'105  i    4   04  0 0 0 0 0 1 0 0
'076  L   56   38  0 0 1 1 1 0 0 0
'077  M   55   37  0 0 1 1 0 1 1 1
'111  o   92   5C  0 1 0 1 1 1 0 0
'080  P  115   73  0 1 1 1 0 0 1 1
'114  r   80   50  0 1 0 1 0 0 0 0
'083  S  109   6D  0 1 1 0 1 1 0 1
'045  -   64   40  0 1 0 0 0 0 0 0
'090  Z    0    0  0 0 0 0 0 0 0 0
